/**
 * @preserve
 * @author    ThemePunch <info@themepunch.com>
 * @link      http://www.themepunch.com/
 * @copyright 2022 ThemePunch
 * @version 6.7.0
 */
!function(){"use strict";window._R_is_Editor?RVS._R=void 0===RVS._R?{}:RVS._R:window._R_is_Editor=!1,jQuery.fn.revolution=jQuery.fn.revolution||{};var t,e=window._R_is_Editor?RVS._R:jQuery.fn.revolution,s=0;function a(t){this.settings=t.shapeBurst.settings;let e=t.shapeBurst.settings;var s;this.camera=new THREE.OrthographicCamera(t.eow/-2,t.eow/2,t.eoh/2,t.eoh/-2),this.scene=new THREE.Scene,(s=this).t_vertexshader="\n            attribute vec3 instancePosition;\n            attribute vec3 explosionValues;\n            attribute vec4 colorValues;\n\n            uniform float uParticleSize;\n            uniform float uTime;\n            uniform float uNoiseTime;\n            uniform float uExplosionTime;\n            uniform float uExplosionRadius;\n\t\t\tuniform float uRandomness;\n\t\t\tuniform float uMaxBurstDur;\n\t\t\tuniform float uExplosionPower;\n\t\t\tuniform bool uFxOn;\n\t\t\tuniform bool uSizeChOnInter;\n\t\t\tuniform float uBlurScale;\n\t\t\tuniform bool uFxOnlyOnInter;\n\n            varying vec4 vColor;\n            varying float vLum;\n\t\t\tvarying vec2 vUv;\n\t\t\tvarying float vEnlarged;\n\n            vec2 hash( vec2 p ) // replace this by something better\n            {\n                p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );\n                return -1.0 + 2.0*fract(sin(p)*43758.5453123);\n            }\n\n            float noise( in vec2 p )\n            {\n                const float K1 = 0.366025404; // (sqrt(3)-1)/2;\n                const float K2 = 0.211324865; // (3-sqrt(3))/6;\n\n                vec2  i = floor( p + (p.x+p.y)*K1 );\n                vec2  a = p - i + (i.x+i.y)*K2;\n                float m = step(a.y,a.x);\n                vec2  o = vec2(m,1.0-m);\n                vec2  b = a - o + K2;\n                vec2  c = a - 1.0 + 2.0*K2;\n                vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );\n                vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));\n                return dot( n, vec3(70.0) );\n            }\n\n            float random(float n) {\n                return fract(sin(n) * 43758.5453123);\n            }\n\n            void main() {\n\t\t\t\tvColor = vec4(colorValues);\n\n\t\t\t\tvUv = uv;\n\n\t\t\t\tvLum = 0.2126 * vColor.r + 0.7152 * vColor.g + 0.0722 * vColor.b;\n\t\t\t\tfloat sizeVar = vLum * uParticleSize + (sin(uNoiseTime + instancePosition.z) * 0.4);\n\n\t\t\t\tfloat burst = 0.0;\n\t\t\t\tvec2 explosionCenter = explosionValues.xy;\n\t\t\t\tfloat explosionTime = explosionValues.z;\n\t\t\t\tvec2 toExplosion = instancePosition.xy - explosionCenter;\n\t\t\t\tfloat explosionDistance = length(toExplosion);\n\n\t\t\t\tfloat randomAdjustValue = uRandomness;\n\n\t\t\t\tvEnlarged = 0.0;\n\n\t\t\t\tif (instancePosition.z > -1.0) {\n\t\t\t\t\tif (explosionDistance < uExplosionRadius && explosionTime >= 0.0 && (uExplosionTime - explosionTime) <= uMaxBurstDur * 3.1415926) {\n\t\t\t\t\t\tfloat t = (uExplosionTime - explosionTime);\n\t\t\t\t\t\trandomAdjustValue += sin(t / uMaxBurstDur) * uExplosionPower;\n\n\t\t\t\t\t\tif(uSizeChOnInter){\n\t\t\t\t\t\t\tfloat blurScale = uBlurScale / 50.0;\n\t\t\t\t\t\t\tsizeVar += sin(t / uMaxBurstDur) * blurScale;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvEnlarged = 1.0;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif(uFxOn){\n\t\t\t\t\tif(uFxOnlyOnInter && vEnlarged == 1.0){\n\t\t\t\t\t\tfloat blurScale = uBlurScale / 50.0;\n\t\t\t\t\t\tsizeVar += sizeVar * blurScale;\n\t\t\t\t\t}\n\t\t\t\t\tif(uFxOnlyOnInter == false){\n\t\t\t\t\t\tfloat blurScale = uBlurScale / 50.0;\n\t\t\t\t\t\tsizeVar += sizeVar * blurScale;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tvec2 noiseOffset = vec2(noise(instancePosition.xy * 0.1 + uTime), noise(instancePosition.yx * 0.1 + uTime)) * randomAdjustValue;\n\n\t\t\t\tvec3 newPosition = ((position * sizeVar) + vec3(noiseOffset + toExplosion * burst, 0.0)) + vec3(instancePosition.xy, 0.0);\n\t\t\t\tgl_Position = projectionMatrix * modelViewMatrix * vec4(newPosition.xy, 0.0, 1.0);\n\t\t\t}\n        ",s.t_fragmentshader="\n            varying vec4 vColor;\n            varying float vLum;\n\t\t\tvarying vec2 vUv;\n\t\t\tvarying float vEnlarged;\n\n\t\t\tuniform float uLuminaBoost;\n\t\t\tuniform float uDarkLimit;\n\t\t\tuniform bool uColorTrue;\n\t\t\tuniform bool uFxOn;\n\t\t\tuniform float uBlurScale;\n\t\t\tuniform bool uFxOnlyOnInter;\n\n            void main() {\n\t\t\t\tvec2 coord = vUv - vec2(0.5);\n\t\t\t\tfloat distance = length(coord);\n\t\t\t\tfloat blurScale = (1.0 - uBlurScale / 100.0) * 0.64;\n\t\t\t\tfloat opacity = smoothstep(0.65, blurScale, distance);\n\n\t\t\t\tfloat opacityVal = vColor.a;\n\n\t\t\t\tif(uFxOn){\n\t\t\t\t\tif(uFxOnlyOnInter && vEnlarged == 1.0){\n\t\t\t\t\t\topacityVal = opacity;\n\t\t\t\t\t}\n\t\t\t\t\tif(uFxOnlyOnInter == false){\n\t\t\t\t\t\topacityVal = opacity;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t\n\n\t\t\t\tif(uColorTrue){\n\t\t\t\t\tgl_FragColor = vec4(vColor.rgb + vec3(uLuminaBoost), opacityVal);\n\t\t\t\t}\n\t\t\t\telse{\n\t\t\t\t\tgl_FragColor = vec4(vec3(vLum + uLuminaBoost), opacityVal);\n\t\t\t\t}                \n\n\t\t\t\tif(vLum < uDarkLimit){\n\t\t\t\t\tgl_FragColor = vec4(0.0);\n\t\t\t\t}\n            }\n        ";let a=new THREE.CircleBufferGeometry(1.5,32);this.instancedGeometry=(new THREE.InstancedBufferGeometry).copy(a);let i=e.loadedImage.ctx.getImageData(0,0,e.loadedImage.canvas.width,e.loadedImage.canvas.height).data,n=e.loadedImage.canvas.width,r=e.loadedImage.canvas.height;const o=t.eow/e.loadedImage.canvas.width,l=t.eoh/e.loadedImage.canvas.height,u=Math.min(o,l);n=e.loadedImage.canvas.width*u,r=e.loadedImage.canvas.height*u;let d=Math.round(Math.sqrt(e.particlesCount*(n/r))),m=Math.round(e.particlesCount/d),p=n/(d-1),h=r/(m-1),c=[],f=[],g=[],v=0,x=0,S=0;for(let t=0;t<m;t++)for(let s=0;s<d;s++){let a=s*p/n,o=t*h/r,l=Math.floor(a*(e.loadedImage.canvas.width-1)),u=4*(Math.floor(o*(e.loadedImage.canvas.height-1))*e.loadedImage.canvas.width+l)+3,d=(.2126*i[u-3]+.7152*i[u-2]+.0722*i[u-1])/255;i[u]>0&&null!=i[u]&&d>e.darkLimit?(c[v++]=s*p-n/2,c[v++]=-t*h+r/2,c[v++]=Math.random()*Math.PI*2-Math.PI,g[S++]=i[u-3]/255,g[S++]=i[u-2]/255,g[S++]=i[u-1]/255,g[S++]=i[u]/255,f[x++]=0,f[x++]=0,f[x++]=-1):(v+=3,x+=3,S+=4)}let b=new Float32Array(c),B=new Float32Array(f),y=new Float32Array(g);this.instancedGeometry.setAttribute("instancePosition",new THREE.InstancedBufferAttribute(b,3)),this.instancedGeometry.setAttribute("explosionValues",new THREE.InstancedBufferAttribute(B,3)),this.instancedGeometry.setAttribute("colorValues",new THREE.InstancedBufferAttribute(y,4)),this.material=new THREE.ShaderMaterial({vertexShader:this.t_vertexshader,fragmentShader:this.t_fragmentshader,uniforms:{uParticleSize:{value:"image"===e.imgSource?e.particleSize/500*Math.min(t.eow,t.eoh):e.particleSize/500*t.eow},uTime:{value:0},uNoiseTime:{value:0},uExplosionTime:{value:0},uExplosionRadius:{value:e.explosionRadius},uRandomness:{value:"image"===e.imgSource?e.randomness/500*Math.min(t.eow,t.eoh):e.randomness/500*t.eow},uLuminaBoost:{value:e.luminaBoost},uDarkLimit:{value:e.darkLimit},uMaxBurstDur:{value:e.maxBurstDur},uExplosionPower:{value:e.explosionPower},uColorTrue:{value:"image"!==e.imgSource||e.colorTrue},uFxOn:{value:e.fxOn},uSizeChOnInter:{value:e.sizeChOnInter},uBlurScale:{value:e.blurScale},uFxOnlyOnInter:{value:e.fxOnlyOnInter}},transparent:!0,blending:THREE.NormalBlending,depthWrite:!1,premultipliedAlpha:!1});let w=new THREE.InstancedMesh(this.instancedGeometry,this.material,b.length/3);this.scene.add(w),t.shapeBurst.canvas.addEventListener("mousemove",this.pointermove.bind(this)),this.renderer=new THREE.WebGLRenderer({antialias:!0,canvas:t.shapeBurst.canvas,alpha:!0}),this.renderer.setPixelRatio(Math.min(e.dpr,window.devicePixelRatio)),this.renderer.setSize(t.eow,t.eoh),this.renderer.setClearColor(0,0),this.bindedRender=this.render.bind(this)}function i(t,e){var s=e.shapeBurst;s.settings.particleSize=parseFloat(s.particleSize)/10,s.settings.randomness=parseFloat(s.randomness)/3,s.settings.luminaBoost=parseFloat(s.luminaBoost)/100,s.settings.explosionRadius=parseFloat(s.explosionRadius),s.settings.maxBurstDur=parseFloat(s.maxBurstDur)/10,s.settings.explosionPower=parseFloat(s.explosionPower),s.settings.parSpeed=parseFloat(s.parSpeed),s.settings.interSpeed=parseFloat(s.interSpeed)/2-.25,s.settings.blurScale=parseFloat(s.blurScale),s.settings.sizeChOnInter=s.sizeChOnInter,s.settings.colorTrue=s.colorTrue,s.settings.fxOn=s.fxOn,s.settings.fxOnlyOnInter=s.fxOnlyOnInter}function n(t){return _R_is_Editor?RVS.LIB.RSSB[t.settings.lid]:e[t.settings.sid]._L[t.settings.lid]}jQuery.extend(!0,e,{shapeBurstBuild:{getBasics:function(){return{parbackground:"default",luminaBoost:0,darkLimit:0,colorTrue:!1,imgSource:"image",textInput:"Roboto",textFont:"Roboto",textFontWeight:"300",textColor:"#ffffff",textFontSize:200,imgSize:"contain",bspos:"center center",particlesCount:15e3,particleSize:15,randomness:20,parSpeed:1,explosionRadius:35,maxBurstDur:10,explosionPower:30,interSpeed:3,sizeChOnInter:!0,transitionAnimTime:30,transitionON:!0,fxOn:!1,blurScale:50,fxOnlyOnInter:!1,dpr:1}}},shapeBurstInit:function(t,s){e.TWOMPI=e.TWOMPI||2*Math.PI,e.DEGTORAD=e.DEGTORAD||Math.PI/180,e.shapeburstUrl=void 0===s.url?"":s.url,THREE.Cache.enabled=!0,e.shapeBurstUtils.observe(t)},shapeBurstUtils:{observe:function(t){e[t].c.on("layerinitialised",(function(s,a){void 0!==e[t]._L[a.layer]&&e[t]._L[a.layer].c[0].className.indexOf("tp-shapeburst")>=0&&e.shapeBurstUtils.initLayer(t,a.layer)})),e[t].c.on("revolution.layeraction",(function(s,a){if(null!=e[t]._L[a.layerid]&&-1!==e[t]._L[a.layerid].c[0].className.indexOf("tp-shapeburst"))if("enterstage"===a.eventtype)null==e[t]._L[a.layerid].shapeBurst&&e.shapeBurstUtils.initLayer(t,a.layerid),e.shapeBurstUtils.fitCameraToObject(e[t]._L[a.layerid]),e[t]._L[a.layerid].shapeBurst.pauseTimer&&e[t]._L[a.layerid].shapeBurst.pauseTimer.kill&&e[t]._L[a.layerid].shapeBurst.pauseTimer.kill();else if("leavestage"===a.eventtype&&e[t]._L[a.layerid]&&e[t]._L[a.layerid].shapeBurst&&e[t]._L[a.layerid].shapeBurst.sburst){var i=e[t]._L[a.layerid].shapeBurst.sburst;e[t]._L[a.layerid].shapeBurst.pauseTimer=tpGS.gsap.delayedCall(e[t]._L[a.layerid].frames.frame_999.timeline.speed/1e3,(function(){i.paused=!0,i.frame=cancelAnimationFrame(i.frame),i.destroy(),e[t]._L[a.layerid].shapeBurst=void 0}))}})),e[t].c.on("leftviewport",(function(){for(var s in e[t]._L)if(e[t]._L.hasOwnProperty(s)&&e[t]._L[s]&&e[t]._L[s].shapeBurst&&e[t]._L[s].shapeBurst.sburst){var a=e[t]._L[s].shapeBurst.sburst;a.paused=!0,a.frame=cancelAnimationFrame(a.frame),a.destroy(),e[t]._L[s].shapeBurst=void 0}})).on("enterviewport",(function(){for(var s in e[t]._L)e[t]._L.hasOwnProperty(s)&&(!e[t]._L[s]||-1===e[t]._L[s].c[0].className.indexOf("tp-shapeburst")||e[t].pr_active_key!=e[t]._L[s].slideIndex&&"all"!=(e[t].carousel?.showLayersAllTime??"")||null==e[t]._L[s].shapeBurst&&e.shapeBurstUtils.initLayer(t,s))}))},initLayer:function(t,s){if(null==e[t]._L[s]||void 0===e[t]._L[s].shapeBurst){var a,i,n=e[t]._L[s];n.shapeBurst=e.shapeBurstUtils.getWebGLCanvas(),n.shapeBurst=jQuery.extend(!0,n.shapeBurst,e.shapeBurstBuild.getBasics());var r=n.shapeBurst;if(r.sid=t,r.lid=s,void 0!==n.wpsdata)for(a in n.wpsdata="object"==typeof n.wpsdata?n.wpsdata:n.wpsdata.split(";"),n.wpsdata)if(n.wpsdata.hasOwnProperty(a))if((n.wpsdata[a]+"").indexOf("{")>=0);else switch((i=n.wpsdata[a].split(":"))[0]){case"pbg":r.parbackground=i[1];break;case"ml":r.luminaBoost=i[1];break;case"md":r.darkLimit=i[1];break;case"mc":r.colorTrue=i[1];break;case"mi":r.imgSource=i[1];break;case"mt":r.textInput=i[1];break;case"mf":r.textFont=i[1];break;case"mw":r.textFontWeight=i[1];break;case"mo":r.textColor=i[1];break;case"ms":r.textFontSize=i[1];break;case"mz":r.imgSize=i[1];break;case"mp":r.bspos=i[1];break;case"pc":r.particlesCount=i[1];break;case"ps":r.particleSize=i[1];break;case"pr":r.randomness=i[1];break;case"pp":r.parSpeed=i[1];break;case"ir":r.explosionRadius=i[1];break;case"id":r.maxBurstDur=i[1];break;case"ip":r.explosionPower=i[1];break;case"ie":r.interSpeed=i[1];break;case"ic":r.sizeChOnInter=i[1];break;case"ta":r.transitionAnimTime=i[1];break;case"tr":r.transitionON=i[1];break;case"fx":r.fxOn=i[1];break;case"fb":r.blurScale=i[1];break;case"fo":r.fxOnlyOnInter=i[1];break;case"dpr":r.dpr=i[1]}n.c.find("canvas").remove(),n.c[0].appendChild(r.canvas),e.shapeBurstUtils.setLayer(n)}},initBackendLayer:function(t){if(_R_is_Editor&&RVS.LIB.RSSB&&RVS.LIB.RSSB[t]&&RVS.LIB.RSSB[t].shapeBurst){var s=RVS.LIB.RSSB[t].shapeBurst;s.initCall&&s.initCall.kill(),s&&s.sburst&&s.sburst.destroy&&s.sburst.destroy()}if(e.TWOMPI=e.TWOMPI||2*Math.PI,e.DEGTORAD=e.DEGTORAD||Math.PI/180,void 0!==RVS&&void 0!==RVS.L&&void 0!==RVS.L[t]&&null!=RVS.L[t].addOns["revslider-shapeburst-addon"]){var a={};_R_is_Editor&&(void 0===RVS.LIB.RSSB&&(RVS.LIB.RSSB={}),RVS.LIB.RSSB[t]=a),a.shapeBurst=e.shapeBurstUtils.getWebGLCanvas(),a.shapeBurst=jQuery.extend(!0,RVS._R.shapeBurstBuild.getBasics(),a.shapeBurst),a.shapeBurst=jQuery.extend(!0,a.shapeBurst,RVS.L[t].addOns["revslider-shapeburst-addon"]),a.lid=t,a.shapeBurst.lid,a.shapeBurst.initCall=tpGS.gsap.delayedCall(.3,(function(){RVS.L[t]&&(a.eow=RVS.L[t].size.width[RVS.screen].v.indexOf&&-1!==RVS.L[t].size.width[RVS.screen].v.indexOf("%")?RVS.H[t].c.width():parseInt(RVS.L[t].size.width[RVS.screen].v,0),a.eoh=RVS.L[t].size.height[RVS.screen].v.indexOf&&-1!==RVS.L[t].size.height[RVS.screen].v.indexOf("%")?RVS.H[t].c.height():parseInt(RVS.L[t].size.height[RVS.screen].v,0),RVS.H[t].c[0].appendChild(a.shapeBurst.canvas),e.shapeBurstUtils.layers=void 0===e.shapeBurstUtils.layers?{}:e.shapeBurstUtils.layers,a.shapeBurst.id=RVS.S.slideId,a.shapeBurst.lid=t,e.shapeBurstUtils.layers[RVS.S.slideId+"_"+t]=a,e.shapeBurstUtils.setLayer(a),e.shapeBurstUtils.fitCameraToObject(a))}))}},setLayer:function(s){var n=s.shapeBurst;void 0===t&&(t=new THREE.Clock),n.settings={},n.settings.particlesCount=parseFloat(n.particlesCount),n.settings.particleSize=parseFloat(n.particleSize)/10,n.settings.randomness=parseFloat(n.randomness)/3,n.settings.luminaBoost=parseFloat(n.luminaBoost)/100,n.settings.darkLimit=parseFloat(n.darkLimit)/200,n.settings.explosionRadius=parseFloat(n.explosionRadius),n.settings.maxBurstDur=parseFloat(n.maxBurstDur)/10,n.settings.explosionPower=parseFloat(n.explosionPower),n.settings.colorTrue=n.colorTrue,n.settings.textFont=n.textFont,n.settings.textFontWeight=n.textFontWeight,n.settings.textColor=n.textColor,n.settings.imgSource=n.imgSource,n.settings.textFontSize=parseFloat(n.textFontSize),n.settings.parSpeed=parseFloat(n.parSpeed),n.settings.interSpeed=parseFloat(n.interSpeed)/2-.25,n.settings.dpr=parseFloat(n.dpr),n.settings.lid=n.lid,n.settings.sid=n.sid,n.settings.mouseData={},n.settings.mouseData.mouseX_old=0,n.settings.mouseData.mouseY_old=0,n.settings.mouseData.lastMouseMoveUpdateTime=0,n.settings.mouseMoveCounter=0,n.settings.transitionAnimCounter=0,n.settings.transitionAnimTime=parseFloat(n.transitionAnimTime),n.settings.transitionON=n.transitionON,n.settings.imgSize=n.imgSize,n.settings.bspos=n.bspos,n.settings.fxOn=n.fxOn,n.settings.blurScale=parseFloat(n.blurScale),n.settings.sizeChOnInter=n.sizeChOnInter,n.settings.fxOnlyOnInter=n.fxOnlyOnInter,i(n.settings,s),_R_is_Editor&&void 0===RVS.ENV.SHAPEBURST_URL&&(RVS.ENV.SHAPEBURST_URL="//"+window.location.host+"/wp-content/plugins/revslider-shapeburst-addon/"),"default"===n.parbackground&&(n.parbackground=_R_is_Editor?RVS.ENV.SHAPEBURST_URL+"/sr6/lib/img.png":e.shapeburstUrl+"/sr6/lib/img.png"),n.settings.loadedImage={},n.settings.loadedImage.canvasTexture=new THREE.CanvasTexture,n.settings.loadedImage.canvas=document.createElement("canvas"),n.settings.loadedImage.url=n.parbackground,"image"===n.imgSource&&function(t,e,s,a,i,n){const r=e.getContext("2d"),o=new Image;s.loadedImage.canvasTexture;o.crossOrigin="Anonymous",o.onload=function(){const t=o.naturalWidth,l=o.naturalHeight,u=t/l;let d=t,m=l;if(e.width=a,e.height=i,r.imageSmoothingEnabled=!1,"contain"===s.imgSize){let e,n;u<a/i?(m=i,d=t*(i/l),e=-(d-a)/2,n=0,-1!==s.bspos.indexOf("right")?e=a-d:-1!==s.bspos.indexOf("left")&&(e=0)):(d=a,m=l*(a/t),e=0,n=-(m-i)/2,-1!==s.bspos.indexOf("bottom")?n=i-m:-1!==s.bspos.indexOf("top")&&(n=0)),r.drawImage(o,e,n,d,m),s.loadedImage.ctx=r}else{let e,n;u>a/i?(m=i,d=t*(i/l),e=-(d-a)/2,n=0,-1!==s.bspos.indexOf("right")?e=a-d:-1!==s.bspos.indexOf("left")&&(e=0)):(d=a,m=l*(a/t),e=0,n=-(m-i)/2,-1!==s.bspos.indexOf("bottom")?n=i-m:-1!==s.bspos.indexOf("top")&&(n=0)),r.drawImage(o,e,n,d,m),s.loadedImage.ctx=r}s.loadedImage.texture=new THREE.Texture(e),s.loadedImage.texture.needsUpdate=!0,n()},o.src=t,s.loadedImage.img=o}(n.settings.loadedImage.url,n.settings.loadedImage.canvas,n.settings,s.eow,s.eoh,(function(){n.sburst=new a(s),n.sburst.lid=s.lid,n.sburst.sid=s.sid,n.sburst.resize(s.eow,s.eoh),n.sburst.render()})),"text"===n.imgSource&&function(t,e,s,a,i,n){const r=e.getContext("2d");s.loadedImage.canvasTexture;r.fillStyle=s.textColor,r.font=`${s.textFontWeight} ${s.textFontSize}px ${s.textFont}`,r.textBaseline="middle";const o=r.measureText(t),l=Math.ceil(o.width),u=s.textFontSize;let d=i/u,m=a/l;e.width=1.2*a,e.height=1.2*i,r.imageSmoothingEnabled=!1;const p=(e.width-l*Math.min(d,m))/2,h=e.height/2;r.clearRect(0,0,e.width,e.height),r.font=`${s.textFontWeight} ${s.textFontSize*Math.min(d,m)}px ${s.textFont}`,r.textBaseline="middle",r.fillStyle=s.textColor,r.fillText(t,p,h),s.loadedImage.ctx=r,s.loadedImage.texture=new THREE.Texture(e),s.loadedImage.texture.needsUpdate=!0,n()}(n.textInput,n.settings.loadedImage.canvas,n.settings,s.eow,s.eoh,(function(){n.sburst=new a(s),n.sburst.lid=s.lid,n.sburst.sid=s.sid,n.sburst.resize(s.eow,s.eoh),n.sburst.render()}))},updateLayer:function(t,s,a,n,r){void 0!==e.shapeBurstUtils.layers[t+"_"+s]&&(e.shapeBurstUtils.layers[t+"_"+s].shapeBurst[a]=n,i(e.shapeBurstUtils.layers[t+"_"+s].shapeBurst.settings,e.shapeBurstUtils.layers[t+"_"+s]),e.shapeBurstUtils.layers[t+"_"+s].shapeBurst.sburst.update())},splitColor:function(t){return 3==(t=tpGS.gsap.utils.splitColor(t)).length&&(t[3]=1),t[0]/=255,t[1]/=255,t[2]/=255,t},fitCameraToObject:function(t){var e,s;_R_is_Editor&&!RVS.H[t.lid]||t.shapeBurst.sburst&&(window._R_is_Editor?(e=Math.round(RVS.H[t.lid].c[0].clientWidth),s=Math.round(RVS.H[t.lid].c[0].clientHeight)):(e=Math.round(t.eow),s=Math.round(t.eoh)),e=isNaN(e)?0:e,s=isNaN(s)?0:s,t.shapeBurst.lastDim={width:e,height:s},t.shapeBurst.sburst.resize(e,s),t.shapeBurst.sburst.paused=!1,cancelAnimationFrame(t.shapeBurst.sburst.frame),t.shapeBurst.sburst.frame=requestAnimationFrame(t.shapeBurst.sburst.bindedRender))},getWebGLCanvas:function(){let t=document.createElement("canvas");return t.style.width="100%",t.style.height="100%",t.style.position="absolute",t.style.top="0px",t.style.left="0px",t.style.zIndex=2,t.width=1600,t.height=1200,{canvas:t}}}}),a.prototype.render=function(a){this.destroyed||this.paused||(this.frame=cancelAnimationFrame(this.frame),this.frame=requestAnimationFrame(this.bindedRender));let i=(o=n(this)).shapeBurst.settings;if(void 0===a||void 0===this.time)return void(this.time=a);let r=(a-this.time)/1600;var o;this.time=a,void 0!==(o=n(this)).shapeBurst.lastDim&&o.shapeBurst.lastDim.width===o.eow&&o.shapeBurst.lastDim.height===o.eoh||e.shapeBurstUtils.fitCameraToObject(o);if(t.getElapsedTime()>s*(1/60)&&(s+=r,i.transitionON&&i.transitionAnimCounter<i.transitionAnimTime)){let t=i.transitionAnimCounter/i.transitionAnimTime,e=Math.cos((t+1)*Math.PI/2)+1,s="image"===i.imgSource?i.randomness/500*Math.min(o.eow,o.eoh):i.randomness/500*o.eow;this.material.uniforms.uRandomness.value=100*e+s,i.transitionAnimCounter++}this.material.uniforms.uTime.value+=.001*i.parSpeed,this.material.uniforms.uNoiseTime.value+=.01*i.parSpeed,this.material.uniforms.uExplosionTime.value+=.05*i.interSpeed,this.renderer.render(this.scene,this.camera)},a.prototype.update=function(){var t=n(this);let e=t.shapeBurst.settings;this.material.uniforms.uParticleSize.value="image"===e.imgSource?e.particleSize/500*Math.min(t.eow,t.eoh):e.particleSize/500*t.eow,this.material.uniforms.uRandomness.value="image"===e.imgSource?e.randomness/500*Math.min(t.eow,t.eoh):e.randomness/500*t.eow,this.material.uniforms.uLuminaBoost.value=e.luminaBoost,this.material.uniforms.uExplosionRadius.value=e.explosionRadius,this.material.uniforms.uMaxBurstDur.value=e.maxBurstDur,this.material.uniforms.uExplosionPower.value=e.explosionPower,this.material.uniforms.uBlurScale.value=e.blurScale,this.material.uniforms.uSizeChOnInter.value=e.sizeChOnInter,this.material.uniforms.uColorTrue.value=e.colorTrue,this.material.uniforms.uFxOn.value=e.fxOn,this.material.uniforms.uFxOnlyOnInter.value=e.fxOnlyOnInter},a.prototype.resize=function(t,e){this.camera.left=-t/2,this.camera.right=t/2,this.camera.top=e/2,this.camera.bottom=-e/2,this.camera.updateProjectionMatrix(),this.camera.position.set(0,0,1),this.camera.lookAt(new THREE.Vector3(0,0,0)),this.renderer.setSize(t,e)},a.prototype.mouseenter=function(t){var e=n(this),s=e.shapeBurst.canvas.getBoundingClientRect();this.mouseX=(t.pageX-s.top)/s.width,this.mouseY=(t.pageY-s.left)/s.height,tpGS.gsap.to(this,{duration:2,lerp:e.shapeBurst.settings.lerp})},a.prototype.mouseleave=function(t){this.mouseX=.5,this.mouseY=.5,tpGS.gsap.to(this,{duration:0,lerp:.001,overwrite:!0})},a.prototype.pointermove=function(t){var e=n(this);let s=e.shapeBurst.settings,a=(new Date).getTime();if(a-s.mouseData.lastMouseMoveUpdateTime>10){s.mouseMoveCounter>5&&(s.mouseMoveCounter=0,s.mouseData.mouseX_old=s.mouseData.mouseX,s.mouseData.mouseY_old=s.mouseData.mouseY),s.mouseMoveCounter++,s.mouseData.mouseX=t.offsetX,s.mouseData.mouseY=t.offsetY;let i=Math.max(Math.abs(s.mouseData.mouseX_old-s.mouseData.mouseX),Math.abs(s.mouseData.mouseY_old-s.mouseData.mouseY))/30;i>1&&(i=1),i<.2&&(i=0);let n=new THREE.Vector2(s.mouseData.mouseX-e.eow/2,-s.mouseData.mouseY+e.eoh/2),r=this.instancedGeometry.attributes.instancePosition.array,o=this.instancedGeometry.attributes.explosionValues.array,l=this.material.uniforms.uExplosionTime.value,u=s.maxBurstDur;for(let t=0;t<r.length;t++){let e=new THREE.Vector2(r[3*t],r[3*t+1]);o[3*t+2],Math.PI;e.distanceTo(n)<this.material.uniforms.uExplosionRadius.value*i&&(o[3*t]=n.x,o[3*t+1]=n.y,l-o[3*t+2]>=3.1415926*u&&(o[3*t+2]=l))}this.instancedGeometry.attributes.explosionValues.needsUpdate=!0,s.lastMouseMoveUpdateTime=a}},a.prototype.mousefollowHandler=function(){let t=n(this).shapeBurst.settings;this.pFrame&&(this.pFrame=window.cancelAnimationFrame(this.pFrame));var s,a,i,r=this.pEvent;s=r.beta-60,a=r.gamma,i=s;var o=Math.abs(this.orientationX-a)>1||Math.abs(this.orientationY-i)>1;if(this.orientationX=a,this.orientationY=i,o){if(e.winW>e.getWinH(t.sid)){var l=a;a=i,i=l}this.px=a,this.py=i}},a.prototype.destroy=function(){this.destroyed=!0,this.renderer&&(this.renderer.dispose(),this.renderer.domElement.remove(),this.renderer.domElement=null),this.renderer=null,this.frame=cancelAnimationFrame(this.frame)},window.RS_MODULES=window.RS_MODULES||{},window.RS_MODULES.shapeburst={loaded:!0,version:"6.7.0"},window.RS_MODULES.checkMinimal&&window.RS_MODULES.checkMinimal()}();